/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.dataexchange;

import java.util.Objects;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.betterx.bclib.api.v2.dataexchange.BaseDataHandler;
import org.jetbrains.annotations.NotNull;

public class DataHandlerDescriptor<T extends PacketPayload<T>> {
    public final Direction DIRECTION;
    @NotNull
    public final class_9139<class_2540, T> STREAM_CODEC;
    public final boolean sendOnJoin;
    public final boolean sendBeforeEnter;
    @NotNull
    public final PayloadFactory<T> PAYLOAD_FACTORY;
    @NotNull
    public final class_8710.class_9154<T> IDENTIFIER;
    @NotNull
    public final Supplier<BaseDataHandler<T>> INSTANCE;
    @NotNull
    public final Supplier<BaseDataHandler<T>> JOIN_INSTANCE;

    public DataHandlerDescriptor(@NotNull Direction direction, @NotNull class_2960 identifier, @NotNull PayloadFactory<T> factory, @NotNull Supplier<BaseDataHandler<T>> instancer) {
        this(direction, identifier, factory, instancer, instancer, false, false);
    }

    public DataHandlerDescriptor(@NotNull Direction direction, @NotNull class_2960 identifier, @NotNull PayloadFactory<T> factory, @NotNull Supplier<BaseDataHandler<T>> instancer, boolean sendOnJoin, boolean sendBeforeEnter) {
        this(direction, identifier, factory, instancer, instancer, sendOnJoin, sendBeforeEnter);
    }

    public DataHandlerDescriptor(@NotNull Direction direction, @NotNull class_2960 identifier, @NotNull PayloadFactory<T> factory, @NotNull Supplier<BaseDataHandler<T>> receiv_instancer, @NotNull Supplier<BaseDataHandler<T>> join_instancer, boolean sendOnJoin, boolean sendBeforeEnter) {
        this.DIRECTION = direction;
        this.INSTANCE = receiv_instancer;
        this.JOIN_INSTANCE = join_instancer;
        this.IDENTIFIER = new class_8710.class_9154(identifier);
        this.sendOnJoin = sendOnJoin;
        this.sendBeforeEnter = sendBeforeEnter;
        this.PAYLOAD_FACTORY = factory;
        this.STREAM_CODEC = class_8710.method_56484(PacketPayload::write, factory::create);
        if (direction == Direction.SERVER_TO_CLIENT) {
            PayloadTypeRegistry.playS2C().register(this.IDENTIFIER, this.STREAM_CODEC);
        } else if (direction == Direction.CLIENT_TO_SERVER) {
            PayloadTypeRegistry.playC2S().register(this.IDENTIFIER, this.STREAM_CODEC);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof class_2960) {
            return o.equals(this.IDENTIFIER);
        }
        if (!(o instanceof DataHandlerDescriptor)) {
            return false;
        }
        DataHandlerDescriptor that = (DataHandlerDescriptor)o;
        return this.IDENTIFIER.equals(that.IDENTIFIER);
    }

    public int hashCode() {
        return Objects.hash(this.IDENTIFIER);
    }

    void receiveFromServer(Object payload, ClientPlayNetworking.Context context) {
        BaseDataHandler<PacketPayload> h = this.INSTANCE.get();
        try (class_310 client = context.client();){
            h.receiveFromServer(client, client.method_1562(), (PacketPayload)payload, context.responseSender());
        }
    }

    void receiveFromClient(Object payload, ServerPlayNetworking.Context context) {
        BaseDataHandler<PacketPayload> h = this.INSTANCE.get();
        h.receiveFromClient(context.player().field_13995, context.player(), context.player().field_13987, (PacketPayload)payload, context.responseSender());
    }

    public static enum Direction {
        CLIENT_TO_SERVER,
        SERVER_TO_CLIENT;

    }

    public static interface PayloadFactory<T extends PacketPayload<T>> {
        public T create(class_2540 var1);
    }

    public static abstract class PacketPayload<T extends PacketPayload<T>>
    implements class_8710 {
        protected final DataHandlerDescriptor<T> descriptor;

        protected PacketPayload(DataHandlerDescriptor<T> desc) {
            this.descriptor = desc;
        }

        protected abstract void write(class_2540 var1);

        @NotNull
        public final class_8710.class_9154<T> method_56479() {
            return this.descriptor.IDENTIFIER;
        }
    }
}

